clear 

use crosscountrydata

ge number=1 if country=="canada"
replace number=2 if country=="france"
replace number=3 if country=="india"
replace number=4 if country=="ireland"
replace number=5 if country=="italy"
replace number=6 if country=="japan"
replace number=7 if country=="portugal"
replace number=8 if country=="singapore"
replace number=9 if country=="sweden"
replace number=10 if country=="us"

ge g99100=ln(share1*y/(share1[_n-1]*y[_n-1])) if country==country[_n-1] & year==year[_n-1]+1 
ge g0100=ln(y/y[_n-1]) if country==country[_n-1] & year==year[_n-1]+1
ge share1lag=share1[_n-1] if country==country[_n-1]

replace g99100=. 								if country=="us" & inlist(year,1987,1988)==1

replace g99100=ln(share1_veall*y_veall/(share1_veall[_n-1]*y_veall[_n-1])) 	if country=="canada" & year>=1983
replace g0100=ln(y_veall/y_veall[_n-1]) 					if country=="canada" & year>=1983
replace share1lag=share1_veall[_n-1] 						if country=="canada" & year>=1983

ge beta99100=.
ge beta99100_1=.
ge beta99100_2=.

ge sebeta99100=.
ge sebeta99100_1=.
ge sebeta99100_2=.

ge early=year<=1982
ge late=year>1982

foreach num of numlist 1/10  {	
	reg g99100 g0100 if number==`num'  & early==1
	replace beta99100_1=_b[g0100] if number==`num'
	replace sebeta99100_1=_se[g0100] if number==`num'
}
foreach num of numlist 1/10  {	
	reg g99100 g0100 if number==`num'  & late==1
	replace beta99100_2=_b[g0100] if number==`num'
	replace sebeta99100_2=_se[g0100] if number==`num'
}

so country year

egen mshare1a=mean(share1lag) if early==1 , by(country)
egen mshare1b=mean(share1lag) if late==1 , by(country)
egen mmshare1a=max(mshare1a), by(country)
egen mmshare1b=max(mshare1b), by(country)
ge dmshare1=mmshare1b-mmshare1a
ge dbeta99100=beta99100_2-beta99100_1
egen mdbeta99100=max(dbeta99100), by(country)
egen mdmshare1=max(dmshare1), by(country)

so country year
reg mdbeta99100 mdmshare1 if country~=country[_n-1] , robust
predict hat1
label variable mdmshare1 " "
label variable mdbeta99100 " "
label variable hat1 " "
scatter mdbeta99100 hat1 mdmshare1, mlabel(country)  c(. l) symbol(t none) ylabel(-1(0.5)2) saving(fig5, replace) l1("Change in top 1% beta from 1970-82 to 1982-2007") b1("Change in average top 1% income share from 1970-82 to 1982-2007") legend(off)
li mdbeta99100 hat1 mdmshare1 if country~=country[_n-1]

